#ifndef __IMAGE_UTIL_HPP__
#define __IMAGE_UTIL_HPP__
/**************************************************************************
 *
 *     This file is part of Chiton.
 *
 *   Chiton is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Chiton is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Chiton.  If not, see <https://www.gnu.org/licenses/>.
 *
 *   Copyright 2020-2023 Ed Martin <edman007@edman007.com>
 *
 **************************************************************************
 */

#include "chiton_config.hpp"
#include "chiton_ffmpeg.hpp"
#include "database.hpp"
#include "system_controller.fwd.hpp"

class ImageUtil {

public:
    ImageUtil(SystemController &sys, Config &cfg);
    ~ImageUtil();

    //write out the source coordinates as a jpeg
    //name is a prefix, full path will be autogenerated based on arguments (date based if start_time is not null)
    //if starttime and fileid is non-null, the database ID is written to file id
    bool write_frame_jpg(const AVFrame *frame, std::string &name, const struct timeval *start_time = NULL, rect src = {-1, -1, 0, 0}, long *file_id = NULL);
    bool write_frame_png(const AVFrame *frame, std::string &name, const struct timeval *start_time = NULL, rect src = {-1, -1, 0, 0}, long *file_id = NULL);

    void set_profile(AVCodecID id, int profile);//set the codec profile (used to download images from HW)
private:
    SystemController &sys;
    Database &db;
    Config &cfg;
    AVCodecID codec_id;//codec being used by HW
    int codec_profile;//codec profile being used by HW
    AVPacket *pkt;//packet buffer

    //Returns a clone of the frame with the new rect applied
    AVFrame* apply_rect(const AVFrame *frame, rect &src);
    bool format_supported(const AVFrame *frame, const AVCodec *codec);//return true if the source is in a native format
    AVPixelFormat get_pix_mpjeg_fmt(const AVPixelFormat *pix_list);//returns the best pixel format from the list, list is terminated by AV_PIX_FMT_NONE
};

#endif
